/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public enum CraftingRecipeCache {
    INSTANCE;

    private static final int MAX_CACHE_SIZE = 1024;
    private final Int2ObjectLinkedOpenHashMap<Optional<CraftingRecipe>> recipeCache = new Int2ObjectLinkedOpenHashMap(1024, 0.25f);

    public Optional<CraftingRecipe> getCachedRecipe(Level world, CraftingContainer inv) {
        int key = this.makeKey(inv);
        if (this.recipeCache.containsKey(key)) {
            return (Optional)this.recipeCache.getAndMoveToFirst(key);
        }
        Optional newRecipe = world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)inv, world);
        if (this.recipeCache.size() == 1024) {
            this.recipeCache.removeLast();
        }
        this.recipeCache.put(key, (Object)newRecipe);
        return newRecipe;
    }

    public void clear() {
        this.recipeCache.clear();
    }

    private int makeKey(CraftingContainer inv) {
        ArrayList<Integer> c = new ArrayList<Integer>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            c.add(i);
            c.add(stack.m_41720_().hashCode());
            if (!stack.m_41782_()) continue;
            c.add(Objects.requireNonNull(stack.m_41783_()).hashCode());
        }
        return Arrays.hashCode((Object[])c.toArray(new Integer[0]));
    }
}

